 /*!
 * Copyright (c) 2005, Freescale Semiconductor
 *
 * Freescale Confidential Proprietary
 * \file    MC13192_hw_config.c
 * \brief   Here are the routines that are used by the MCU to initialize
 *          the MC13192.
 * \author  a19259
 * \version 4.1a
 * \date    2005/07/29 02:27:50 
 * 
 * \b Description:
 *
 * The main routine is the one that initializes the MC13192.There are
 * also included the Disable/Restore MC13192 interrupts commands.
 *
 * \b Department: Freescale Radio Products Division 
 *
 * \b Project: SMAC (Simple Media Access Controller)
 *
 * \b History:
 * - 16/11/2005 Doc. update to Doxygen compliant by Mario Rodriguez r12369c
 */ 

#include "smac_pub_def.h"
#include "smac_mcu_hw_config.h"
#include "smac_drivers.h"
#include "smac_MC13192_hw_config.h"
#include "hprfgw_rfDiagnostics.h"
#include "smac_MC13192_regs.h"
#include "hprfgw_config.h"

/* Globals */
extern UINT8 gu8IRQValue;		//!< IRQ value.

/* externs */
extern void SPIDrvWrite(UINT8 addr, UINT16 content);
extern UINT16 SPIDrvRead(UINT8 addr);
extern UINT32 Rfdiags_LowLevelPhyChipId;


/*!
 * \brief MC13192Init: Initialize the MC13192 register map.
 *
 */
void MC13192Init(void)
{
    UINT16 PhyVersion = 0;

    // Read the PHY Version (chip ID)
    PhyVersion = SPIDrvRead(VERSION_REG); /* VERSION_REG */
    PhyVersion = PhyVersion & VERSION_MASK;   /* Mask unwanted bits (VERSION_MASK) */

    // Store it for diag purpose
    Rfdiags_LowLevelPhyChipId = (UINT32)PhyVersion;

    /* If it is a new version of MCF13202, then overprogram these registers */
    if (PhyVersion == MC13202_CHIP_ID3)   /* MC13202_CHIP_ID3 */
    {
        /* Refer Chip Id register description of 13202 or change errata from freescale */
        SPIDrvWrite(0x31,0xA0C0);
        SPIDrvWrite(0x34,0xFEC6);
    }

/* Please refer to document MC13192RM for hidden register initialization */
    SPIDrvWrite(0x11,0x20FF);   /* Eliminate Unlock Conditions due to L01 */
    SPIDrvWrite(0x1B,0x8000);   /* Disable TC1. */
    SPIDrvWrite(0x1D,0x8000);   /* Disable TC2. */
    SPIDrvWrite(0x1F,0x8000);   /* Disable TC3. */
    SPIDrvWrite(0x21,0x8000);   /* Disable TC4. */
    SPIDrvWrite(0x07,0x0E00);   /* Enable CLKo in Doze */
#ifdef RF_COMBINE_MODE
    // MC13202 chip support	
    // rf common mode, bias, 
    SPIDrvWrite(0x07,0x0E00|(CT_BIAS_EN|RF_SWITCH_MODE)); 
#endif
#if MC13192_IRQ_PULLUP_ENABLE
	SPIDrvWrite(0x0C,0x0380);   /* IRQ pull-up enable. */
#else
	SPIDrvWrite(0x0C,0x0300);   /* IRQ pull-up disable. */
#endif
    (void)SPIDrvRead(0x25);           /* Sets the reset indicator bit */
	// SPIDrvWrite(0x04,0xA08D);   /* New cal value */
    // MNT - 6/12/2007 - the CCA threshold and the power level offset will now be set by the 
    // PLMESetCCAThreshPowerComp function called in the RF_Intfc_Init function
    // SPIDrvWrite(0x04,0x2074);   /* New cal value */
    SPIDrvWrite(0x08,0xFFF7);   /* Preferred injection */
    SPIDrvWrite(0x05,0x8351);   /* Acoma, TC1, Doze, ATTN masks, LO1, CRC */
    SPIDrvWrite(0x06,0x4720);   /* CCA, TX, RX, energy detect */
	// SPIDrvWrite(0x06,0x2097);   /* CCA, TX, RX, energy detect */
 
    /* Read the status register to clear any undesired IRQs. */
    (void)SPIDrvRead(0x24);           /* Clear the status register, if set */
    gu8RTxMode = IDLE_MODE;     /* Update global to reflect MC13192 status */

    gu8TxPktLenDefault = (SPIDrvRead(TX_PKT_LEN) & TX_PKT_LEN_RESERVED);
}


/*!
 * \brief MC13192DisableInterrupts : Disable MC13192 interrupts
 *
 */
void MC13192DisableInterrupts(void)
{
    
    MC13192_IRQ_Disable();  /* Save context & disable the MC13192 interrupt source */
}


/*!
 * \brief MC13192RestoreInterrupts : Restore MC13192 interrupts to previous condition
 *
 */
void MC13192RestoreInterrupts(void)
{
    MC13192_IRQ_Enable();   /* Restore the context of the IRQ register from global */
}


